% objective: find the likely global minimum of parameters and using
% bootstrap method to find the confidence intervals
% Author: Xueyang Feng (fengx@seas.wustl.edu)
% date: 09/01/2011

clear
clc

lb_umax_L=0.3;
lb_umax_A=0.1;
lb_umax_P=0.1;
lb_Ksl=10;
lb_Ksa=10;
lb_Ksp=10;
lb_kpl=0;
lb_kal=0;
lb_kap=0;
lb_ke=0;
lb_tL=4;
lb_Yxl=0.01696;
lb_Yxa=0.01056;
lb_Yxp=0.01560;


ub_umax_L=0.6;
ub_umax_A=0.4;
ub_umax_P=0.4;
ub_Ksl=20;
ub_Ksa=20;
ub_Ksp=20;
ub_kpl=2;
ub_kal=2;
ub_kap=2;
ub_ke=0.1;
ub_tL=12;
ub_Yxl=0.02544;
ub_Yxa=0.01584;
ub_Yxp=0.02340;

lb(1)=lb_umax_L;
lb(2)=lb_umax_A;
lb(3)=lb_umax_P;
lb(4)=lb_Ksl;
lb(5)=lb_Ksa;
lb(6)=lb_Ksp;
lb(7)=lb_kpl;
lb(8)=lb_kal;
lb(9)=lb_kap;
lb(10)=lb_ke;
lb(11)=lb_tL;
lb(12)=lb_Yxl;
lb(13)=lb_Yxa;
lb(14)=lb_Yxp;


ub(1)=ub_umax_L;
ub(2)=ub_umax_A;
ub(3)=ub_umax_P;
ub(4)=ub_Ksl;
ub(5)=ub_Ksa;
ub(6)=ub_Ksp;
ub(7)=ub_kpl;
ub(8)=ub_kal;
ub(9)=ub_kap;
ub(10)=ub_ke;
ub(11)=ub_tL;
ub(12)=ub_Yxl;
ub(13)=ub_Yxa;
ub(14)=ub_Yxp;

num_gf=100;
num_param=14;

param_gf=zeros(14,num_gf);
obj_gf=zeros(1,num_gf);

A=[0 0 0 0 0 0 0 0 0 0 0 -1 0 1
   0 1 -1 0 0 0 0 0 0 0 0 0 0 0];
b=[0;0];

for i=1:num_gf
    
    ini=[
        lb(1)+rand*(ub(1)-lb(1));
        lb(2)+rand*(ub(2)-lb(2));
        lb(3)+rand*(ub(3)-lb(3));
        lb(4)+rand*(ub(4)-lb(4));
        lb(5)+rand*(ub(5)-lb(5));
        lb(6)+rand*(ub(6)-lb(6));
        lb(7)+rand*(ub(7)-lb(7));
        lb(8)+rand*(ub(8)-lb(8));
        lb(9)+rand*(ub(9)-lb(9));
        lb(10)+rand*(ub(10)-lb(10));
        lb(11)+rand*(ub(11)-lb(11));
        lb(12)+rand*(ub(12)-lb(12));
        lb(13)+rand*(ub(13)-lb(13));
        lb(14)+rand*(ub(14)-lb(14));
        ];
    
    options=optimset('Algorithm','interior-point');
    
    [x, fval]= fmincon('obj_monod_final',ini,A,b,[],[],lb,ub,[],options);
    param_gf(:,i)=x(:,1);
    obj_gf(i)=fval;
end

%% set for ini
[obj_min, index_min]=min(obj_gf);
ini_SA=param_gf(:,index_min);

%% bootstrap for confidence intervals
global sequence;
num_bootstrap=1000;
sequenceMatrix=myrandint(54,num_bootstrap,[1:54]);

param_bootstrap=zeros(num_param,num_bootstrap);
obj_bootstrap=zeros(1,num_bootstrap);

for i=1:num_bootstrap
    sequence(:,1)=sequenceMatrix(:,i);
    ini=ini_SA;
        
    options=optimset('Algorithm','interior-point');
    
    [x, fval]= fmincon('obj_monod_bootstrap_final',ini,A,b,[],[],lb,ub,[],options);
    param_bootstrap(:,i)=x(:,1);
    obj_bootstrap(i)=fval;
end

